/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.item.ItemEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.plant.PlantEntityAssetDictionary;
import technology.rocketjump.undermount.entities.model.EntityType;

@Singleton
public class CompleteAssetDictionary {
    private final HumanoidEntityAssetDictionary humanoidEntityAssetDictionary;
    private final PlantEntityAssetDictionary plantEntityAssetDictionary;
    private final ItemEntityAssetDictionary itemEntityAssetDictionary;

    @Inject
    public CompleteAssetDictionary(HumanoidEntityAssetDictionary humanoidEntityAssetDictionary, PlantEntityAssetDictionary plantEntityAssetDictionary, ItemEntityAssetDictionary itemEntityAssetDictionary) {
        this.humanoidEntityAssetDictionary = humanoidEntityAssetDictionary;
        this.plantEntityAssetDictionary = plantEntityAssetDictionary;
        this.itemEntityAssetDictionary = itemEntityAssetDictionary;
    }

    public EntityAsset getByUniqueName(String uniqueAssetName, EntityType entityType) {
        switch (entityType) {
            case HUMANOID: {
                return this.humanoidEntityAssetDictionary.getByUniqueName(uniqueAssetName);
            }
            case PLANT: {
                return this.plantEntityAssetDictionary.getByUniqueName(uniqueAssetName);
            }
            case ITEM: {
                return this.itemEntityAssetDictionary.getByUniqueName(uniqueAssetName);
            }
        }
        throw new RuntimeException("Not yet implemented type " + (Object)((Object)entityType) + " in " + this.getClass().getName());
    }
}

